/*
 * @(#)ClassNameSpace.java  1.0  23. M�rz 2004
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.oo.objectmodelbsh;

import ch.hslu.cm.oo.objectmodel.*;
import bsh.*;
import java.io.*;
/**
 * ClassNameSpace.
 *
 * @author  Werner Randelshofer
 * @version 1.0 23. M�rz 2004  Created.
 */
public class ClassNameSpace extends NameSpace {
    private OMBshClass simulatedClass;
    
    public ClassNameSpace(OMBshClass simulatedClass) {
        this(null, null, null);
        
        this.simulatedClass = simulatedClass;
    }
    
    public ClassNameSpace( NameSpace parent, String name ) {
        // Note: in this case parent must have a class manager.
        this( parent, null, name);
    }
    
    public ClassNameSpace( BshClassManager classManager, String name ) {
        this( null, classManager, name);
    }
    
    public ClassNameSpace(NameSpace parent, BshClassManager classManager, String name ) {
        super(parent, classManager, name);
    }
    
    public void setName( String name ) {
        super.setName(name);
    }
    
    /**
     * The name of this namespace.  If the namespace is a method body
     * namespace then this is the name of the method.  If it's a class or
     * class instance then it's the name of the class.
     */
    public String getName() {
        return super.getName();
    }
    
    /**
     * Resolve name to an object through this namespace.
     */
    public Object get( String name, Interpreter interpreter )
    throws UtilEvalError {
        return super.get(name, interpreter);
    }
    
    /**
     * Set the variable through this namespace.
     * This method obeys the LOCALSCOPING property to determine how variables
     * are set.
     * <p>
     * Note: this method is primarily intended for use internally.  If you use
     * this method outside of the bsh package and wish to set variables with
     * primitive values you will have to wrap them using bsh.Primitive.
     * @see bsh.Primitive
     * <p>
     * Setting a new variable (which didn't exist before) or removing
     * a variable causes a namespace change.
     *
     * @param strictJava specifies whether strict java rules are applied.
     */
    public void	setVariable( String name, Object value, boolean strictJava )
    throws UtilEvalError {
        super.setVariable(name, value, strictJava);
    }
    
    /**
     * Remove the variable from the namespace.
     */
    public void unsetVariable( String name ) {
        super.unsetVariable(name);
    }
    
    /**
     * Get the names of variables defined in this namespace.
     * (This does not show variables in parent namespaces).
     */
    public String [] getVariableNames() {
        return super.getVariableNames();
    }
    
    /**
     * Get the names of methods declared in this namespace.
     * (This does not include methods in parent namespaces).
     */
    public String[] getMethodNames() {
        System.out.println(this+".getMethodNames()");
        return super.getMethodNames();
    }
    
    /**
     * Get the methods defined in this namespace.
     * (This does not show methods in parent namespaces).
     * Note: This will probably be renamed getDeclaredMethods()
     */
    public BshMethod[] getMethods() {
        System.out.println(this+".getMethods()");
        return super.getMethods();
    }
    
    
    
    /**
     * Get the parent namespace.
     * Note: this isn't quite the same as getSuper().
     * getSuper() returns 'this' if we are at the root namespace.
     */
    public NameSpace getParent() {
        return super.getParent();
    }
    
    /**
     * Get the parent namespace' This reference or this namespace' This
     * reference if we are the top.
     */
    public This getSuper( Interpreter declaringInterpreter ) {
        return super.getSuper(declaringInterpreter);
    }
    
    /**
     * Get the top level namespace or this namespace if we are the top.
     * Note: this method should probably return type bsh.This to be consistent
     * with getThis();
     */
    public This getGlobal( Interpreter declaringInterpreter ) {
        return super.getGlobal(declaringInterpreter);
    }
    
    
    
    public BshClassManager getClassManager() {
        return super.getClassManager();
    }
    
    /**
     * Used for serialization
     */
    public void prune() {
        super.prune();
    }
    
    public void setParent( NameSpace parent ) {
        super.setParent(parent);
    }
    
    
    /**
     * Get the specified variable in this namespace.
     * @param recurse If recurse is true then we recursively search through
     * parent namespaces for the variable.
     * <p>
     * Note: this method is primarily intended for use internally.  If you use
     * this method outside of the bsh package you will have to use
     * Primitive.unwrap() to get primitive values.
     * @see Primitive#unwrap( Object )
     *
     * @return The variable value or Primitive.VOID if it is not defined.
     */
    public Object getVariable( String name, boolean recurse )
    throws UtilEvalError {
         System.out.println(this+".getVariable("+name+")");
       return super.getVariable(name, recurse);
    }
    
    /**
     * Locate a variable and return the Variable object with optional
     * recursion through parent name spaces.
     * <p/>
     * If this namespace is static, return only static variables.
     *
     * @return the Variable value or null if it is not defined
     */
    protected Variable getVariableImpl( String name, boolean recurse )
    throws UtilEvalError {
        System.out.println(this+".getVariableImpl("+name+")");
        return super.getVariableImpl(name, recurse);
    }
    
        /*
                Get variables declared in this namespace.
         */
    public Variable[] getDeclaredVariables() {
        return super.getDeclaredVariables();
    }
    
    
    /**
     * Declare a variable in the local scope and set its initial value.
     * Value may be null to indicate that we would like the default value
     * for the variable type. (e.g.  0 for integer types, null for object
     * types).  An existing typed variable may only be set to the same type.
     * If an untyped variable of the same name exists it will be overridden
     * with the new typed var.
     * The set will perform a Types.getAssignableForm() on the value if
     * necessary.
     *
     * <p>
     * Note: this method is primarily intended for use internally.  If you use
     * this method outside of the bsh package and wish to set variables with
     * primitive values you will have to wrap them using bsh.Primitive.
     * @see bsh.Primitive
     *
     * @param value If value is null, you'll get the default value for the type
     * @param modifiers may be null
     */
    public void	setTypedVariable(
    String	name, Class type, Object value,	Modifiers modifiers )
    throws UtilEvalError {
        super.setTypedVariable(name, type, value, modifiers);
    }
    
    
    
    /**
     * Note: this is primarily for internal use.
     * @see Interpreter#source( String )
     * @see Interpreter#eval( String )
     */
    public void	setMethod( String name, BshMethod method )
    throws UtilEvalError {
        super.setMethod(name, method);
    }
    
    /**
     * Get the bsh method matching the specified signature declared in
     * this name space or a parent.
     * <p>
     * Note: this method is primarily intended for use internally.  If you use
     * this method outside of the bsh package you will have to be familiar
     * with BeanShell's use of the Primitive wrapper class.
     * @see bsh.Primitive
     * @return the BshMethod or null if not found
     * @param declaredOnly if true then only methods declared directly in this
     * namespace will be found and no inherited or imported methods will
     * be visible.
     */
    public BshMethod getMethod(
    String name, Class [] sig, boolean declaredOnly )
    throws UtilEvalError {
        System.out.println(this+".getMethod("+name+")");
        return super.getMethod(name, sig, declaredOnly);
    }
    
    /**
     * Import a class name.
     * Subsequent imports override earlier ones
     */
    public void	importClass(String name) {
        super.importClass(name);
    }
    
    /**
     * subsequent imports override earlier ones
     */
    public void	importPackage(String name) {
        super.importPackage(name);
    }
    
    /**
     * Import scripted or compiled BeanShell commands in the following package
     * in the classpath.  You may use either "/" path or "." package notation.
     * e.g. importCommands("/bsh/commands") or importCommands("bsh.commands")
     * are equivalent.  If a relative path style specifier is used then it is
     * made into an absolute path by prepending "/".
     */
    public void	importCommands(String name) {
        super.importCommands(name);
    }
    
    /**
     * A command is a scripted method or compiled command class implementing a
     * specified method signature.  Commands are loaded from the classpath
     * and may be imported using the importCommands() method.
     * <p/>
     *
     * This method searches the imported commands packages for a script or
     * command object corresponding to the name of the method.  If it is a
     * script the script is sourced into this namespace and the BshMethod for
     * the requested signature is returned.  If it is a compiled class the
     * class is returned.  (Compiled command classes implement static invoke()
     * methods).
     * <p/>
     *
     * The imported packages are searched in reverse order, so that later
     * imports take priority.
     * Currently only the first object (script or class) with the appropriate
     * name is checked.  If another, overloaded form, is located in another
     * package it will not currently be found.  This could be fixed.
     * <p/>
     *
     * @return a BshMethod, Class, or null if no such command is found.
     * @param name is the name of the desired command method
     * @param argTypes is the signature of the desired command method.
     * @throws UtilEvalError if loadScriptedCommand throws UtilEvalError
     * i.e. on errors loading a script that was found
     */
    public Object getCommand(
    String name, Class [] argTypes, Interpreter interpreter )
    throws UtilEvalError {
        return super.getCommand(name, argTypes, interpreter);
    }
    
    protected BshMethod getImportedMethod( String name, Class [] sig )
    throws UtilEvalError {
        return super.getImportedMethod(name, sig);
    }
    
    protected Variable getImportedVar( String name )
    throws UtilEvalError {
        return super.getImportedVar(name);
    }
    
    
    /**
     * Load a class through this namespace taking into account imports.
     * The class search will proceed through the parent namespaces if
     * necessary.
     *
     * @return null if not found.
     */
    public Class getClass(String name)
    throws UtilEvalError {
        return super.getClass(name);
    }
    
    
    /**
     * Implements NameSource
     * @return all variable and method names in this and all parent
     * namespaces
     */
    public String []getAllNames() {
        return super.getAllNames();
    }
    
    /*
     * Implements NameSource
     * Add a listener who is notified upon changes to names in this space.
     */
    public void addNameSourceListener( NameSource.Listener listener ) {
        super.addNameSourceListener(listener);
    }
    
    /**
     * Perform "import *;" causing the entire classpath to be mapped.
     * This can take a while.
     */
    public void doSuperImport()
    throws UtilEvalError {
        super.doSuperImport();
    }
    
    
    /**
     * Invoke a method in this namespace with the specified args and
     * interpreter reference.  No caller information or call stack is
     * required.  The method will appear as if called externally from Java.
     * <p>
     *
     * @see bsh.This#invokeMethod(
     * String methodName, Object [] args, Interpreter interpreter,
     * CallStack callstack, SimpleNode callerInfo, boolean )
     */
    public Object invokeMethod(
    String methodName, Object [] args, Interpreter interpreter )
    throws EvalError {
        System.out.println(this+".invokeMethod("+methodName+")");
        return super.invokeMethod(methodName, args, interpreter, null, null);
        //return invokeMethod(methodName, args, interpreter, null, null );
    }
    /**
     * This method simply delegates to This.invokeMethod();
     * <p>
     * @see bsh.This.invokeMethod(
     * String methodName, Object [] args, Interpreter interpreter,
     * CallStack callstack, SimpleNode callerInfo )
     * /
     * public Object invokeMethod(
     * String methodName, Object [] args, Interpreter interpreter,
     * CallStack callstack, SimpleNode callerInfo )
     * throws EvalError {
     * return getThis( interpreter ).invokeMethod(
     * methodName, args, interpreter, callstack, callerInfo,
     * false/*declaredOnly* / );
     * }
     */
    /**
     * Clear all cached classes and names
     */
    public void classLoaderChanged() {
        super.classLoaderChanged();
    }
    
    /**
     * Clear all cached classes and names
     */
    public void nameSpaceChanged() {
        super.nameSpaceChanged();
    }
    
    /**
     * Import standard packages.  Currently:
     * <pre>
     * importClass("bsh.EvalError");
     * importClass("bsh.Interpreter");
     * importPackage("javax.swing.event");
     * importPackage("javax.swing");
     * importPackage("java.awt.event");
     * importPackage("java.awt");
     * importPackage("java.net");
     * importPackage("java.util");
     * importPackage("java.io");
     * importPackage("java.lang");
     * importCommands("/bsh/commands");
     * </pre>
     */
    public void loadDefaultImports() {
        super.loadDefaultImports();
        /**
         * Note: the resolver looks through these in reverse order, per
         * precedence rules...  so for max efficiency put the most common
         * ones later.
         */
       /*
        importClass("bsh.EvalError");
        importClass("bsh.Interpreter");
        importPackage("javax.swing.event");
        importPackage("javax.swing");
        importPackage("java.awt.event");
        importPackage("java.awt");
        importPackage("java.net");
        importPackage("java.util");
        importPackage("java.io");
        importPackage("java.lang");
        importCommands("/bsh/commands");
        */
    }
    
    public int getInvocationLine() {
        return super.getInvocationLine();
    }
    public String getInvocationText() {
        return super.getInvocationText();
    }
    
    /**
     * Clear all variables, methods, and imports from this namespace.
     * If this namespace is the root, it will be reset to the default
     * imports.
     * @see #loadDefaultImports()
     */
    public void clear() {
        super.clear();
    }
    
    /**
     * Import a compiled Java object's methods and variables into this
     * namespace.  When no scripted method / command or variable is found
     * locally in this namespace method / fields of the object will be
     * checked.  Objects are checked in the order of import with later imports
     * taking precedence.
     * <p/>
     */
        /*
                Note: this impor pattern is becoming common... could factor it out into
                an importedObject Vector class.
         */
    public void importObject( Object obj ) {
        super.importObject(obj);
    }
    
    /**
     */
    public void importStatic( Class clas ) {
        super.importStatic(clas);
    }
}
